{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

	<div class="flex:col">
		<div class="intro">
			<div class="intro__bg">
				<img src="{$ASSETS_URL}/images/bg/3.jpg" alt="{$section.name}">
			</div>
			<div class="flex:col-max">
				<div class="intro__info">
					<div class="text-tmp title-44 title-tt-up txt-18 all-center marg-all-10 color-white max-w-1000">
						<h2>{$section.name}</h2>
						{fetch_nominees_count assign=countJobs section=$section.sectionId}
						<p>Количество участников ({$countJobs.count})</p>
					</div>
				</div>
			</div>
		</div>
	</div>



	<section class="flex:col pad-tb-100">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-100">
				<div class="grid:fr-1 g-gap-40">

					{fetch_sections assign=catalogSections from=$section.sectionId status="V"}{if !empty($catalogSections)}
					<div class="btns">
						<button class="btn accent-1 transparent large btn-filter_js active" data-id="0">Все номинации</button>
						{foreach item=subcatalog from=$catalogSections name=catalogSections}
						<button class="btn accent-1 transparent large btn-filter_js" data-id="{$subcatalog.sectionId}">{$subcatalog.name}</button>
						{/foreach}
					</div>
					{/if}

					{fetch_nominees perPage=30 assign=jobs section=$section.sectionId assignPagination=pagination page=$page path=$section.path seFriendly=true image=true}{if !empty($jobs)}
					<div class="grid:fr-3 max g-gap-20">
						{foreach from=$jobs item=job}
						<a class="card card_js" data-id="{$job.sectionId}" href="{$SITE_URL}{$job.url}">
							<div class="card__img"><img src="{if isset($job.image.original)}{$job.image.original}{/if}" alt="{$job.title}"></div>
							<div class="card__info">
								<div class="text-tmp title-20 all-center"><h2>{$job.brand}</h2></div>
							</div>
						</a>
						{/foreach}
					</div>
					{/if}
				</div>
			</div>
		</div>
	</section>
	
	{* УЧАСТНИКИ ПРЕМИИ *}
	<section class="flex:col pad-b-50 bg-clip-bot shadow-block">
		<div class="flex:col pad-t-100 bg-accent-3">
			<div class="flex:col-max">
				<div class="grid:fr-1 g-gap-40">
					<div class="text-tmp title-44 title-tt-up txt-18 max-w-1000">
						<h2>УЧАСТНИКИ ПРЕМИИ</h2>
					</div>
					{fetch_sections assign=nominations from=3 status="V" getContent=true}{if !empty($nominations)}
					<div class="grid:fr-1 g-gap-20">
						{foreach item=nomination from=$nominations name=nominations}
						{fetch_nominees_count assign=countJobs section=$nomination.sectionId}
						<a class="wide-line" href="{$SITE_URL}{$nomination.url}"><span>{$nomination.name}</span><span>{$countJobs.count}</span></a>
						{/foreach}
					</div>
					{/if}
				</div>
			</div>
		</div>
	</section>
	{* /УЧАСТНИКИ ПРЕМИИ *}


</main>


{include file="footer.tpl"}