<?php

use Mnv\Core\Locale\I18N;
use Mnv\Modules\Search;

require_once "../includes/visitor.inc.php";

$query     = request()->get('query', '');
$sectionId = (int) request()->get('sectionId');
$page      = (int) request()->get('page');

if (request()->ajax()) {

    $response = [];

    $search = new Search();
    $search->contents += $search->section($query);
    $search->contents += $search->content($query);


    if (!empty($search->contents)) {
        $response = array('status' => 200, 'message' => I18N::locale("По Вашему запросу найдено...", "Сизнинг сўровингиз бўйича топилди...", "Found by your request...", "Sizning so'rovingiz bo'yicha topildi..."), 'contents' =>  $search->contents);
    } else {
        $response = array('status' => 200, 'message' =>  I18N::locale("По Вашему запросу ничего не найдено...", "Сизнинг сўровингиз учун ҳеч нарса топилмади...", "Nothing was found for your query...", "Sizning so'rovingiz bo'yicha hech narsa topilmadi..."), 'contents' => $search->contents);
    }

    return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

} else {

    if ($page < 1) {
        $page = 1;
    }

    $smarty->assign('page', $page);
    $smarty->assign('query', $query);

    /* saving visit */
    writeSearchVisit($query, $page);

    $smarty->display('search.tpl');

    /* precise load time */
    updateLoadTime();
}