<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\Config;

function smarty_function_fetch_nominees($params, &$smarty){

    global $fetchedArticles;

	$assign        = fetch_getParam('assign', $params, 'jobs');
//	$fields        = fetch_getParam('fields', $params, 'jobId, sectionId, fileName, publishedOn, isFeatured, orderBy, lang_code, title, alias, telegram, link, links, content, url');
	$fields        = fetch_getParam('fields', $params, 'j.sectionId, j.jobId, j.brand, j.url, jd.lang_code, jd.title, jd.content');
	$status        = fetch_getParam('status', $params, 'V');
    $limit         = (int) fetch_getParam('limit', $params);
    $perPage       = (int) fetch_getParam('perPage', $params, $limit);
    $isFeatured    = fetch_getParam('isFeatured', $params, NULL);

    $query         = fetch_getParam('query', $params, NULL);
    $match         = fetch_getParam('match', $params, 'any');
    $order         = fetch_getParam('order', $params, NULL);
    $orderBy       = fetch_getParam('orderBy', $params, $order);
    $section       = fetch_getParam('section', $params);
    $jobId         = fetch_getParam('jobId', $params);

    $consumer      = fetch_getParam('consumer', $params, NULL);
    $expert      = fetch_getParam('expert', $params, NULL);

    $page          = (int) fetch_getParam('page', $params);
    $skip          = fetch_getParam('skip', $params, NULL);
    $noSubsections = (boolean) fetch_getParam('noSubsections', $params, false);

    $type        = fetch_getParam('type', $params, '');

    $sectionInfo  = fetch_getParam('sectionInfo', $params, false);

    $countPage = !(isMobile()) ? 4 : 2;

    $assignPagination = fetch_getParam('assignPagination', $params);
    $path             = fetch_getParam('path', $params);
    $seFriendly       = (boolean) fetch_getParam('seFriendly', $params);
    $pnFirst          = (int) fetch_getParam('pnFirst', $params, 0);
    $pnBefore         = (int) fetch_getParam('pnBefore', $params, $countPage);
    $pnAfter          = (int) fetch_getParam('pnAfter', $params, $countPage);
    $pnLast           = (int) fetch_getParam('pnLast', $params, 0);

    if (empty($assign)) {
        $smarty->_trigger_fatal_error('fetch_nominees: "assign" must not be empty');
        return;
    }

    if (empty($path)) $path = array();

    /** conditions */
    filterJobs($status, $isFeatured, $jobId, $orderBy, $query, $type);

    /** query conditions */
    fetch_jobs_addQueryConditions($query, $match, $fields, $orderBy);
    /** add section conditions */
    fetch_jobs_addSectionConditions($section, $noSubsections);
    /** skipping articles */
    fetch_jobs_addSkipConditions($skip);
    /** checking article fields */
    fetch_jobs_filterFields($fields);

    if (!empty($status)) connect()->where('j.status', $status);
    if (!empty($expert)) connect()->where('j.expert', $expert);
    if (!empty($consumer)) connect()->where('j.consumer', $consumer);

    if ($page < 1) $page = 1;
    if ($perPage < 1) $perPage = 10;

    $jobs = connect('jobs AS j')->usingJoin('jobs_description AS jd', 'jobId')->select($fields)
        ->where('lang_code', Config::getValue('website_language'))
        ->orderBy('j.addedOn ASC')
        ->pagination($perPage, $page)->getAll('array');

//    print_r(connect()->getQuery().PHP_EOL);
//    print_r($jobs);

    $jobs = prepareJobs($jobs, $sectionInfo);

    $smarty->assign($assign, $jobs);


    /* saving fetched articles for SKIP ability */
    if (empty($fetchedArticles[$assign])) $fetchedArticles[$assign] = array();
    if (!empty($jobs)) foreach ($jobs as $job) $fetchedArticles[$assign][] = $job['jobId'];


    if (!empty($assignPagination)) {

        /** conditions */
        filterJobs($status, $isFeatured, $jobId, $orderBy, $query, $type);

        if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);

        /** query conditions */
        fetch_jobs_addQueryConditions($query, $match, $fields, $orderBy);
        /** add section conditions */
        fetch_jobs_addSectionConditions($section, $noSubsections);
        /** skipping articles */
        fetch_jobs_addSkipConditions($skip);
        /** checking article fields */
        fetch_jobs_filterFields($fields);

        /** page numbering */
        $total = connect('jobs')->countDistinct('jobId')->getValue();
        if (is_array($path)) {
            $path = SITE_URL . '/' . basename($_SERVER['PHP_SELF']) . '?' . (!empty($path) ? implode('&', $path).'&' : '');
            $seFriendly = false;
        }
        $pagination = getPageNums($total, $page, $perPage, $pnFirst, $pnBefore, $pnAfter, $pnLast, $path, $seFriendly);
        $smarty->assign($assignPagination, $pagination);
    }

	return null;
}

function filterJobs($status, $isFeatured, $jobId, $orderBy, $query, $type)
{
    global $gmNow;

//    connect()->where('publishedOn','<=', $gmNow);
    if (!empty($status)) connect()->where('status', $status);
//    if (!is_null($isFeatured)) connect()->where('isFeatured',$isFeatured ? 1 : 0);
    if (!empty($jobId)) connect()->where('jobId', '!=', $jobId);
    if (!empty($type)) connect()->where('type',  $type);
    if (is_null($orderBy)) {
        connect()->orderBy(is_null($query) ? 'publishedOn DESC' : '');
    } else {
        connect()->orderBy($orderBy);
    }
}
?>