<?php


namespace Mnv\Modules;

use Mnv\Core\Locale\I18N;

/**
 * Class Survey
 * @package Mnv\Modules
 */
class Survey
{
    /** @var string */
    protected string $table = 'survey';
    /** @var string  */
    protected string $primaryKey = 'id';

    protected string $orderBy = 'id DESC';

    public $response = [];

    public $ratings = array(
        1 => 'Очень плохо',
        2 => 'Неудовлетворительно',
        3 => 'Хорошо',
        4 => 'Отлично',
    );

    public function __construct($sectionId, $color)
    {
        $this->ratings = array(
            1 => I18N::locale("Очень плохо", "Жуда ёмон", "Very bad", "Juda yomon"),
            2 => I18N::locale("Неудовлетворительно", "Қониқарсиз", "Unsatisfactory", "Qoniqarsiz"),
            3 => I18N::locale("Хорошо", "Яхши", "Well", "Yaxshi"),
            4 => I18N::locale("Отлично", "Ажойиб", "Great", "Ajoyib"),
        );

        $section = connect('sections')->select('sectionId, name')->where('sectionId', $sectionId)->get('array');

        $this->response['id'] = $section['sectionId'];
        $this->response['name'] = $section['name'];
        $this->response['data']['color'] = $color;
    }

    public function stats()
    {
        $results = connect()->table($this->table)->select('rating')->count('rating', 'count')->groupBy('rating')->getAll('array');
        if (!empty($results)) {
            foreach ($results as $result) {
                $this->response['data']['x_data'][] =  $this->ratings[$result['rating']];
                $this->response['data']['y_data'][] =  $result['count'];
            }
        }

    }
}
