<?php

namespace Mnv\Modules\Participants;

/**
 * Class SiteUserException
 * @package Mnv\Modules\Participants
 */
class SiteUserException  extends \Exception
{
    public $message;
    public $error;


    /**
     * SiteUserException constructor.
     *
     * @param int $code код ошибки.
     * @param string|array $message сообщение об ошибке.
     * @param string|null $data имя параметра, которое привело к этой ошибке.
     */
    public function __construct($code, $message, $data = null)
    {
        $this->code       = $code;
        $this->message    = $message;
        $this->data       = $data;

        // prepare error data
        $this->error = ['code' => $this->code];

        if ($this->message) {
            $this->error['message'] = $this->message;
        }

        if ($this->data) {
            $this->error['data'] = $this->data;
        }
    }

    public $data;

}