<?php


namespace Mnv\Modules;

use Mnv\Core\Locale\I18N;

/**
 * Class MainCharts
 * @package Mnv\Modules
 */
class MainCharts
{

    /** Курс UZCE */
    public function courseCharts($colors): array
    {
        $categories = [];

        $section = connect('sections')->select('sectionId, name')->where('sectionId', 106)->get('array');
        $response['id']   = $section['sectionId'];
        $response['name'] = $section['name'];

        $currencies = connect('currency')->orderBy('id ASC')->getAll('array');
        foreach ($currencies as $idx => $currency) {
            $categories[$idx]['id']   = $currency['id'];
            $categories[$idx]['name'] = $currency['name'].'/SUM';

            $collection =  collect(connect('course')->select('*')->where('status', 'V')->where('currencyId', $currency['id'])->orderBy('date DESC')->groupBy('date')->limit(20)->getAll('array'));
            $echarts = $collection->sortBy('date', SORT_NATURAL)->values()->all();
            foreach ($echarts as $chart) {
                $categories[$idx]['data']['x_data']['data'][]  = adjustTime($chart['date'], false, 'd.m.Y');

                $categories[$idx]['data']['y_data']['data'][]  = (float)$chart['cost'];
                $categories[$idx]['data']['y_data']['color']  = $colors[$idx];
//                $categories[$idx]['data']['y_data']['name']  = I18N::locale("Курс", "Kurs", "Course");
                $categories[$idx]['data']['y_data']['type']  = "line";
            }
        }

        $response['categoryes'] = $categories;

        return $response;
    }


    /** Валютный рынок */
    public function courseCurrency($colors): array
    {
        $categories = [];

        $section = connect('sections')->select('sectionId, name')->where('sectionId', 112)->get('array');
        $response['id'] = $section['sectionId'];
        $response['name'] = $section['name'];

        $currencies = connect('currency')->orderBy('id ASC')->getAll('array');
        foreach ($currencies as $idx => $currency) {
            $categories[$idx]['id'] = $currency['id'];
            $categories[$idx]['name'] = $currency['name'].'/SUM';

            $collection = collect(connect('course')->select('*')->where('status', 'V')->where('currencyId', $currency['id'])->orderBy('date DESC')->groupBy('date')->limit(20)->getAll('array'));
            $echarts = $collection->sortBy('date', SORT_NATURAL)->values()->all();
            foreach ($echarts as $chart) {
                $categories[$idx]['data']['x_data']['data'][]  = adjustTime($chart['date'], false, 'd.m.Y');

                $categories[$idx]['data']['y_data']['data'][] = (float)$chart['volume'];
                $categories[$idx]['data']['y_data']['name']   = I18N::locale("Объём торгов", "Савдолар ҳажми", "Trading volume", "Savdolar hajmi");
                $categories[$idx]['data']['y_data']['type']   = "line";
                $categories[$idx]['data']['y_data']['color']  = $colors[$idx][1];

                $categories[$idx]['data']['line_data']['data'][]  = (float)$chart['cost'];
                $categories[$idx]['data']['line_data']['name']  = I18N::locale("Курс", "Курс", "Exchange rate", "Kurs");
                $categories[$idx]['data']['line_data']['type']  = "line";
                $categories[$idx]['data']['line_data']['color']  = $colors[$idx][0];
            }
        }

        $response['categoryes'] = $categories;

        return $response;
    }


    /** Денежный рынок */
    public function marketMoney($colors): array
    {

        $categories = [];

        $section = connect('sections')->select('sectionId, name')->where('sectionId', 113)->get('array');
        $response['id'] = $section['sectionId'];
        $response['name'] = $section['name'];

        $periods = connect('periods')->orderBy('id ASC')->getAll('array');
        foreach ($periods as $idx => $period) {
            $categories[$idx]['id']     = $period['id'];
            $categories[$idx]['name']   = $period['name'];

            $collection = collect(connect('market_money')->select('*')->where('status', 'V')->where('periodId', $period['id'])->orderBy('date DESC')->groupBy('date')->limit(20)->getAll('array'));
            $echarts = $collection->sortBy('date', SORT_NATURAL)->values()->all();
            foreach ($echarts as $chart) {
                $categories[$idx]['data']['x_data']['data'][]  = adjustTime($chart['date'], false, 'd.m.Y');

//                1 515 000 000 000
//                str_pad($sku, 9, '0', STR_PAD_LEFT)

                if (!empty($chart['volume']) || $chart['volume'] > 0.00) {
                    $volume = $chart['volume'] / 1000;
                } else {
                    $volume = $chart['volume'];
                }
                $categories[$idx]['data']['y_data']['data'][] = $volume;
                $categories[$idx]['data']['y_data']['name']   = I18N::locale("Объём торгов (трлн.сум)", "Савдолар ҳажми (трлн.сўм)", "Trading volume (trillion UZS)", "Savdolar hajmi (trln.so'm)");
                $categories[$idx]['data']['y_data']['type']   = "line";
                $categories[$idx]['data']['y_data']['color']  = $colors[$idx][1];

                $categories[$idx]['data']['line_data']['data'][] = (float)$chart['rate'];
                $categories[$idx]['data']['line_data']['name']   = I18N::locale("Срвз. ставка", "Ўрт. тортилг. ставка", "Weight. aver. rate ", "O'rt. tortilg. stavka");
                $categories[$idx]['data']['line_data']['type']   = "line";
                $categories[$idx]['data']['line_data']['color']  = $colors[$idx][0];
            }
        }

        $response['categoryes'] = $categories;

        return $response;
    }


    /** Долговой рынок */
    public function marketDebt($colors): array
    {
        $section = connect('sections')->select('sectionId, name')->where('sectionId', 119)->get('array');

        $response['id'] = $section['sectionId'];
        $response['name'] = $section['name'];

        $categories = [];

        $subSections = connect('sections')->select('parentId, sectionId, name')->where('status', 'V')->where('parentId', $section['sectionId'])->getAll('array');
        foreach ($subSections as $idx => $subSection) {
            $categories[$idx]['id'] = $subSection['sectionId'];
            $categories[$idx]['name'] = $subSection['name'];

            // ГБЦ МЭФ
            if ($subSection['sectionId'] == 120) {
                $categories[$idx]['data'] = $this->getEchartsMinistryFinance($colors, $idx);
            }

            // Облигации ЦБ
            if ($subSection['sectionId'] == 121) {
                $categories[$idx]['data'] = $this->getEchartsBonds($colors, $idx);
            }

            // Вторичные торги
            if ($subSection['sectionId'] == 122) {
                $categories[$idx]['data'] = $this->getEchartsSecondaryTrades($colors, $idx);
            }

        }
        $response['categoryes'] = $categories;

        return $response;
    }

    // Государственные ценные бумаги Минфина
    private function getEchartsMinistryFinance($colors, $idx): array
    {
        $data = [];
        $echarts = connect('tables')->select('*')->where('status', 'V')->where('sectionId', 37)->orderBy('date DESC')->limit(20)->getAll('array');
        $collection = collect($echarts);
        $echarts = $collection->sortBy('date', SORT_NATURAL)->values()->all();

        foreach ($echarts as $chart) {
            $data['x_data']['data'][] = adjustTime($chart['date'], false, 'd.m.Y');

            $data['y_data']['data'][] = (float)str_replace(",", ".",$chart['columnC']);
            $data['y_data']['name']   = I18N::locale("Объём эмиссии (млрд. сум)", "Чиқарилиш ҳажми (млрд. сўм)", "Volume of issue (billion UZS)", "Chiqarilish hajmi (mlrd. so'm)");
            $data['y_data']['type']   = "line";
            $data['y_data']['color']  = $colors[$idx][0];

            $data['y_data_second']['data'][]  = (float)str_replace(",", ".", $chart['columnE']);
            $data['y_data_second']['name']    = I18N::locale("Объём торгов (млрд. сум)", "Савдолар ҳажми (млрд. сўм)", "Trading volume (billion UZS)", "Савдолар ҳажми (млрд. сўм)");
            $data['y_data_second']['type']    = "line";
            $data['y_data_second']['color']   = $colors[$idx][1];

            $data['line_data']['data'][]  = (float)str_replace(",", ".", $chart['columnF']);
            $data['line_data']['name']   = I18N::locale("Средневз. доходность", "Ўрт. тортилг. даромадлилик", "Weight. aver. yield", "O'rt. tortilg. daromadlilik");
            $data['line_data']['color']  = $colors[$idx][2];
        }

        return $data;
    }

    private function getEchartsBonds($colors, $idx): array
    {
        $data = [];
        $collection = collect(connect('tables')->select('date, columnC, columnE, columnF')->where('status', 'V')->where('sectionId', 38)->orderBy('date DESC')->limit(20)->getAll('array'));
        $echarts = $collection->sortBy('date', SORT_NATURAL)->values()->all();

        foreach ($echarts as $chart) {
            $data['x_data']['data'][] = adjustTime($chart['date'], false, 'd.m.Y');

            $data['y_data']['data'][] = (float)str_replace(",", ".",$chart['columnC']);
            $data['y_data']['name']   = I18N::locale("Объём эмиссии (млрд. сум)", "Чиқарилиш ҳажми (млрд. сўм)", "Volume of issue (billion UZS)","Chiqarilish hajmi (mlrd. so'm)");
            $data['y_data']['type']   = "line";
            $data['y_data']['color']  = $colors[$idx][0];

            $data['y_data_second']['data'][] = (float)str_replace(",", ".", $chart['columnE']);
            $data['y_data_second']['name']   = I18N::locale("Объём торгов (млрд. сум)", "Савдолар ҳажми (млрд. сўм)", "Trading volume (billion UZS)", "Savdolar hajmi (mlrd. so'm)");
            $data['y_data_second']['type']   = "line";
            $data['y_data_second']['color']  = $colors[$idx][1];

            $data['line_data']['data'][] = (float)str_replace(",", ".", $chart['columnF']);
            $data['line_data']['name']   = I18N::locale("Средневз. доходность", "Ўрт. тортилг. даромадлилик", "Weight. aver. yield", "O'rt. tortilg. daromadlilik");
            $data['line_data']['color']  = $colors[$idx][2];
        }

        return $data;
    }

    private function getEchartsSecondaryTrades($colors, $idx): array
    {
        $data = [];
        $echarts = connect('tables')->select('*')->where('status', 'V')->where('sectionId', 118)->orderBy('date DESC')->limit(20)->getAll('array');
        $collection = collect($echarts);
        $echarts = $collection->sortBy('date', SORT_NATURAL)->values()->all();

        foreach ($echarts as $chart) {
            $data['x_data']['data'][] = adjustTime($chart['date'], false, 'd.m.Y');

            $data['y_data']['data'][] = (float)str_replace(",", ".",$chart['columnE']);
            $data['y_data']['name']   = I18N::locale("Объём сделок (млрд. сум)", "Битимлар ҳажми (млрд. сўм)", "Volume of transactions (billion UZS)", "Bitimlar hajmi (mlrd. so'm)");
            $data['y_data']['type']   = "line";
            $data['y_data']['color']  = $colors[$idx][0];

            $data['y_data_second']['data'][]   = (float)str_replace(",", ".", $chart['columnH']);
            $data['y_data_second']['name']  = I18N::locale("Цена сделок в % к номиналу", "Номинал қийматга нисбатан битимлар нархи, %да", "Deal price in % to face value", "Nominal qiymatga nisbatan bitimlar narxi, %da");
            $data['y_data_second']['type']  = "line";
            $data['y_data_second']['color'] = $colors[$idx][1];
        }

        return $data;
    }



//    public function repoTransactions($colors)
//    {
//        $section = connect('sections')->select('sectionId, name')->where('sectionId', 114)->get('array');
//
//        $response['id'] = $section['sectionId'];
//        $response['name'] = $section['name'];
//        $response['name_data'] = [
//            I18N::locale("Курс", "Курс", "Курс"),
//            I18N::locale("Объём торговли", "Объём торговли", "Объём торговли")
//        ];
//
//        return $response;
//    }
}