<?php

return array(

    'upload_dir'    => '/uploads/',

    // imagine / intervention
    'image_generation' => 'imagine',

    // 0 - Автоматически / 1 - Imagick / 2 - GD
    'image_library' => 0,

    // Настройки php.ini upload_max_filesize и post_max_size имеет приоритет над следующим параметром max_file_size: in Megabytes
    'max_file_size' => 10,
    'min_file_size' => 1,

    'max_up_size' => 2,
    // Максимальное количество файлов для каталога загрузки:
//    'max_number_of_files' => null,

    'max_width'     => 2000,
    'max_height'    => 2000,

    'min_width'     => 1,
    'min_height'    => 1,

//    'sizes'         => array('large', 'medium', 'small'),

    'ext_img'       => array( 'jpg', 'jpeg', 'png', 'gif', 'bmp'), //Images
    'ext_copy_img'  => array( 'svg', 'ico' ),
    'ext_file'      => array( 'doc', 'docx', 'rtf', 'pdf', 'xls', 'xlsx', 'txt', 'csv', 'html', 'xhtml', 'psd', 'sql', 'log', 'fla', 'xml', 'ade', 'adp', 'mdb', 'accdb', 'ppt', 'pptx', 'odt', 'ots', 'ott', 'odb', 'odg', 'otp', 'otg', 'odf', 'ods', 'odp', 'css', 'ai', 'kmz','dwg', 'dxf', 'hpgl', 'plt', 'spl', 'step', 'stp', 'iges', 'igs', 'sat', 'cgm', 'tiff',''), //Files
    'ext_video'     => array( 'mov', 'mpeg', 'm4v', 'mp4', 'avi', 'mpg', 'wma', "flv", "webm" ), //Video
    'ext_music'     => array( 'mp3', 'mpga', 'm4a', 'ac3', 'aiff', 'mid', 'ogg', 'wav' ), //Audio
    'ext_misc'      => array( 'zip', 'rar', 'gz', 'tar', 'dmg' ), //Archives


    'hidden_image_folders'  => array('admin', 'large', 'medium', 'small'),
    'hidden_folders'        => array('vendor', 'large', 'medium', 'small'),

    'large' => array(
        'max_width' => 1920,
        'max_height' => 1080
    ),
    'medium' => array(
        'max_width' => 800,
        'max_height' => 600
    ),
    'small' => array(
        'max_width' => 250,
        'max_height' => 250
    ),
    'print_response' => true,
    'accept_file_types' => '/\.(gif|jpe?g|png|webp)$/i',

    // Команда или путь к двоичному файлу ImageMagick identify:
    'identify_bin' => 'identify',

);