<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/jobs?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/jobs" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">

		<div class="row">
			<div class="col-md-8">

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.sectionId)}text-danger{/if}">Номинация</label>
                                        {html_options options=$sections name="job[sectionId]" id="sectionId" selected=$job.sectionId|default:'' class="form-control select-search select"}
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">Имя файла</label>
										<input type="text" class="form-control" id="url" autocomplete="off" name="job[fileName]" value="{$job.filename|default:''}">
										<span class="fs-sm text-danger">(Имя файла заполняется автоматически, так же можно оставить пустым или вписать вручную.)</span>
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label">{general:filename}</label>
										<input type="text" class="form-control" autocomplete="off" name="job[url]" value="{$job.url|default:''}" disabled  readonly>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">Контактное лицо</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.brand)}text-danger{/if}">Название Компании / Бренд</label>
										<input type="text" class="form-control" id="brand" name="job[brand]" value="{$job.brand|default:''}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Контактное лицо (Имя и фамилия)</label>
										<input type="text" class="form-control" name="job[fullName]" value="{$job.fullName|default:''}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group mb-3">
										<label class="form-label">ИНН компании</label>
										<input type="text" class="form-control" name="job[inn]" value="{$job.inn|default:''}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group mb-3">
										<label class="form-label">Номер телефона</label>
										<input type="text" class="form-control" name="job[phone]" value="{$job.phone|default:''}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group mb-3">
										<label class="form-label">E-mail</label>
										<input type="text" class="form-control" name="job[email]" value="{$job.email|default:''}">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="card">
					<div class="card-header d-sm-flex pt-sm-0 pb-0">
						<h6 class="align-self-sm-center mb-sm-0">{general:card:description}</h6>
						<div class="ms-sm-auto">
							<ul class="nav nav-tabs nav-tabs-underline card-header-tabs mb-0" role="tablist">
                                {foreach from=$languages item=language key=prefix name=languages}
									<li class="nav-item" role="presentation">
										<a href="#card-underline-{$prefix}" class="nav-link {if $prefix eq $adminLanguage}active{/if}" data-bs-toggle="tab" aria-selected="true" role="tab">
											<img src="/admin/assets/lang/{$prefix}.svg" class="w-24px me-2" alt="{$prefix}">
										</a>
									</li>
                                {/foreach}
							</ul>
						</div>
					</div>

					<div class="card-body tab-content p-0">
                        {foreach from=$languages item=language key=prefix name=languages}
						<div class="tab-pane fade {if $prefix eq $adminLanguage}active show{/if}" id="card-underline-{$prefix}" role="tabpanel">
							<div class="row m-2">
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label">Укажите ссылку на Youtube (Видеоролик / Видео презентация бренда)</label>
										<input type="text" class="form-control" autocomplete="off" name="description[{$prefix}][youtube]" value="{$job.description[$prefix].youtube|default:''}">
									</div>
								</div>

							</div>
							<div class="row">
								<div class="col-md-12">
									<div class="form-group">
										<textarea id="description" name="description[{$prefix}][content]" class="description">{$job.description[$prefix].content|default:''}</textarea>
									</div>
								</div>
							</div>
						</div>
                        {/foreach}

					</div>
				</div>

			</div>

			<div class="col-md-4">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="job[status]" array=$statuses selected=$job.status|default:'V'  class="form-group mb-3"}
                            {* /field status *}

                            {* field isFeatured *}
                            {include "components/fields/select.tpl" id="consumer" title="Голосование потребителей" field="job[consumer]" array=$paramIsFeatured selected=$job.consumer|default:0 class="form-group mb-3"}
                            {* /field isFeatured *}

							{* field isFeatured *}
                            {include "components/fields/select.tpl" id="expert" title="Голосование экспертов" field="job[expert]" array=$paramIsFeatured selected=$job.expert|default:0 class="form-group mb-3"}
                            {* /field isFeatured *}

							{* field isFeatured *}
                            {include "components/fields/select.tpl" id="payment" title="Статус оплаты" field="job[payment]" array=$paramIsFeatured selected=$job.payment|default:0 class="form-group mb-3"}
                            {* /field isFeatured *}

							{* field isFeatured *}
{*                            {include "components/fields/select.tpl" id="isFeatured" title="{articles:misc:featured}" field="job[isFeatured]" array=$paramIsFeatured selected=$job.isFeatured|default:0 class="form-group mb-3"}*}
                            {* /field isFeatured *}
							{* field isFeatured *}
                            {include "components/fields/select.tpl" id="bots" title="Передавать в бот" field="job[bot]" array=$bots selected=$job.bot|default:'Y' class="form-group mb-3"}
                            {* /field isFeatured *}

							<div class="form-group mb-3">
								<label class="form-label is-visible">{articles:misc:publishDate}</label>
								<div class="input-group">
									<span class="input-group-text"><i class="ph-calendar"></i></span>
									<input type="text" class="form-control date-range-single" name="job[publishedOn]" value="{$job.publishedOn|default:$adjustedNow}" readonly>
								</div>
							</div>


						</div>

                        {if isset($job.addedOn) && isset($job.modifiedOn)}
							<div class="card-footer hstack gap-3 justify-content-between">
								<div class="text-muted">
									<ul class="list list-unstyled mb-0 fs-sm">
	                                    <li>{general:created}</li>
	                                    <li>{general:modified}</li>
									</ul>
								</div>
								<div class="hstack gap-1">
									<ul class="list list-unstyled mb-0 fs-sm">
	                                    <li>{$job.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$job.addedBy.loginName|default:"{general:unknownUser}"})</li>
	                                    <li>{$job.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$job.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
									</ul>
								</div>
							</div>
                        {/if}
					</div>
				</div>

                {* image preview *}
                {include file="components/image-preview.tpl"
                image="{if isset($job.image)}{$job.image.original}{/if}"
                id="{if isset($job.imageId)}{$job.imageId}{/if}"
                module='job'}
                {* /image preview *}

				{* FILE *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">Презентация (pdf)</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="form-group" id="pdfs">
								{foreach from=$languages item=language key=prefix name=languages}
								<div class="form-group mb-3">
									{if !empty($job.pdf[{$prefix}])}
										<figure class="docs mb-2" id="docs-item-{$prefix}-{$job.pdf[{$prefix}].imageId}">
											<div class="input-group">
												<a class="input-group-text" href="{$job.pdf[{$prefix}].original}" target="_blank"><img src="/admin/assets/ico/{$job.pdf[{$prefix}].fileFormat}.svg" width="30"/></a>
												<input type="text" class="form-control" value="{$job.pdf[{$prefix}].fileName}" placeholder="" readonly>
												<button type="button" class="btn btn-danger" onclick="deletePdf({$job.pdf[{$prefix}].imageId}, 'job', '{$prefix}');"><i class="ph-trash"></i></button>
											</div>
										</figure>
									{/if}
									<button type="button" class="btn btn-sm btn-primary btn-upload btn-docs read-more" data-type="pdf" data-path="/" data-lang="{$prefix}" data-action="read_more"><img src="/admin/assets/lang/{$prefix}.svg" class="w-24px me-2" alt="{$prefix}"><i class="ph-file-pdf me-2"></i> {general:uploadFile} {$prefix|upper} </button>
								</div>
									{/foreach}
							</div>
						</div>
					</div>
				</div>

				<div class="card">
					<div class="card-header d-sm-flex pt-sm-0 pb-0">
						<h6 class="align-self-sm-center mb-sm-0">{general:card:seo}</h6>
						<div class="ms-sm-auto">
							<ul class="nav nav-tabs nav-tabs-underline card-header-tabs mb-0" role="tablist">
                                {foreach from=$languages item=language key=prefix name=languages}
									<li class="nav-item" role="presentation">
										<a href="#card-seo-{$prefix}" class="nav-link {if $prefix eq $adminLanguage}active{/if}" data-bs-toggle="tab" aria-selected="true" role="tab">
											<img src="/admin/assets/lang/{$prefix}.svg" class="w-24px me-2" alt="{$prefix}">
										</a>
									</li>
                                {/foreach}
							</ul>
						</div>
					</div>

					<div class="card-body tab-content p-0">
                        {foreach from=$languages item=language key=prefix name=languages}
							<div class="tab-pane fade {if $prefix eq $adminLanguage}active show{/if}" id="card-pdf-{$prefix}" role="tabpanel">
								<div class="card-body flex-column flex-md-row m-0">
									<div class="form-group mb-3">
										<label class="form-label is-visible">{general:keywords}</label>
										<textarea id="keywords"  name="description[{$prefix}][keywords]" class="form-control" rows="3">{$job.description[$prefix].keywords|default:''}</textarea>
									</div>
									<div class="form-group">
										<label class="form-label">{general:description}</label>
										<textarea id="description" name="description[{$prefix}][description]" class="form-control" rows="3">{$job.description[$prefix].description|default:''}</textarea>
									</div>
								</div>

							</div>
                        {/foreach}

					</div>
				</div>

			</div>

			<div class="col-md-12 main main_buttons text-center">
                {if isset($job.jobId)}<input type="hidden" class="form-control" id="id" name="id" value="{$job.jobId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>


    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Работа сохранен', type: 'success', timeout: 1500 }).show(); {/if}

{*        {if isset($errors.title)} new Noty({ text: '{articles:errors:1}', type: 'error', timeout: 2500 }).show();{/if}*}
        {if isset($errors.sectionId)} new Noty({ text: 'Выберите номинацию', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Работа не сохранен', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: 'Нет ни одного раздела', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileName)} new Noty({ text: '{articles:errors:7}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameProhibited)} new Noty({ text: 'Такое имя файла запрещено.', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameCharacters)} new Noty({ text: 'Имя файла может состоять только из следующих символов: A-Z a-z 0-9 - _', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: 'Работа с таким URL уже существует. Введите другой URL.', type: 'error', timeout: 2500 }).show(); {/if}

    });

    function notFound() {
        new Noty({ text: '{articles:errors:6}', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }

    function successSortImageMessage() {
        new Noty({ text: 'Порядковый номер изменен', type: 'success', timeout: 1500 }).show();
    }

    $(function () {
        function e() { fileName_touched || $("#url").val(n()) }
        function n() { return fileName = $("#brand").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() }
        function l(e) { for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) { var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o } return t }
        fileName_touched = !0, ($("#url").val() == n() || "" == $("#url").val()) && (fileName_touched = !1), $("#url").change( function () { fileName_touched = !0 }), $("#brand").keyup( function () { e() })
    });
</script>
