
<!-- Page header -->
{capture name="buttons"}
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/comments" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/brands"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<!-- Content area -->
<div class="content">

	<div class="row">
		<div class="col-md-12">
			<div class="card border shadow-sm">
                {include file="views/stats/form/selectors.tpl" filter=true url="{$adminUrl}/comments" filterDate=true}
			</div>

			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-togglable table-striped table-hover" id="comments">
						<thead>
						<tr>
							<th data-hide="image" class="text-center">ДАТА</th>
							<th data-toggle="true">Одобрен</th>
							<th data-hide="phone" class="text-center">Комментарий</th>
							<th data-hide="phone, tablet" class="text-center">АВТОР</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if $comments}
							<tbody>

							<form action="{$adminUrl}/comments" method="post">
								<input type="hidden" name="action" value="bulk">
								<input type="hidden" name="query" value="{if isset($query)}{$query}{/if}">
								<input type="hidden" name="status" value="{if isset($status)}{$status}{/if}">


                                {foreach item=comment from=$comments name=comments}
									<tr id="comment-{$comment.commentId}" class="{if $comment.status eq 'pending'}table-warning{elseif $comment.status eq 'spam'}table-danger{/if}">
										<td class="text-nowrap">{$comment.addedOn nofilter}</td>
										<td class="text-center text-nowrap">{$comment.statusName}</td>
										<td class="text-start" width="100%">{$comment.content|strip_tags|truncate:100 nofilter}</td>
										<td class="text-start text-nowrap" width="100%"> {$comment.authorName|truncate:20} <a href="mailto:{$comment.authorEmail}"> {$comment.authorEmail}</a></td>

										<td class="text-center">
											<div class="d-inline-flex">
												<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/comment?action=edit&id={$comment.commentId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
												<div class="dropdown">
													<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
													<div class="dropdown-menu dropdown-menu-right">
														<a class="dropdown-item" href="{$adminUrl}/comment?action=edit&id={$comment.commentId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i>  {general:edit}</a>
														<div class="dropdown-divider"></div>
														<button class="dropdown-item text-danger" name="bulk[{$comment.commentId}]" value="3"><i class="ph-trash me-2"></i> {general:delete}</button>
													</div>
												</div>
											</div>
										</td>
									</tr>
                                {/foreach}
							</form>
							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/comments" params="{$buildQueryString}"}
			</div>
		</div>

	</div>
</div>


<script>
    $(document).ready(function () {
        {if isset($errors.access_denied)} new Noty({ text: '{comments:errors:0}', type: 'error' }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{comments:errors:1}', type: 'error' }).show(); {/if}
        {if isset($errors.comment_not_found)} new Noty({ text: '{comments:errors:2}', type: 'error' }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{comments:messages:0}', type: 'success' }).show(); {/if}
        {if isset($messages.bulk_save)} new Noty({ text: '{comments:messages:2}', type: 'success' }).show(); {/if}
    });
</script>


