<script src="/admin/assets/js/plugins/internationalization/i18next.min.js"></script>
<script src="/admin/assets/js/plugins/internationalization/i18nextHttpBackend.min.js"></script>
<script src="/admin/assets/js/plugins/internationalization/i18nextBrowserLanguageDetector.min.js"></script>
{literal}
<script>
    const I18nextCallbacks = function() {
        // Noty.js
        const _componentNoty = function(message) {
            if (typeof Noty == 'undefined') {
                console.warn('Warning - noty.min.js is not loaded.');
                return;
            }

            new Noty({ text: message, type: 'info', theme: 'limitless', layout: 'topRight', timeout: 2500}).show();
        };

        const _componentI18nextCallbacks = function() {
            if (typeof i18next == 'undefined') {
                console.warn('Warning - i18next.min.js is not loaded.');
                return;
            }

            // Define main elements
            const elements = document.querySelectorAll('.language-switch .dropdown-item'), selector = document.querySelectorAll('[data-i18n]'),
                enLangClass = 'en',
                ruLangClass = 'ru';

            i18next.use(i18nextHttpBackend).use(i18nextBrowserLanguageDetector).init({
                    backend: {
                        loadPath: '/admin/locales/{{lng}}.json'
                    },
                    debug: true,
                    fallbackLng: 'ru'
                },
                function (err, t) {
                    selector.forEach(function(item) {
                        item.innerHTML = i18next.t(item.getAttribute("data-i18n"));
                    });
                });

            // Do stuff when i18Next is initialized
            i18next.on('initialized', function() {

                // Notification
                // _componentNoty('i18Next has been initialized. <br> The following language has beed detected: ' + '<span class="fw-semibold text-uppercase">' + i18next.language + '</span>');

                // English
                if(i18next.language == "en") {
                    document.querySelector('.' + enLangClass).classList.add('active');
                    document.querySelector('.language-switch .navbar-nav-link').innerHTML = document.querySelector('.' + enLangClass).innerHTML;
                }
                // Ukrainian
                if(i18next.language == "ru") {
                    document.querySelector('.' + ruLangClass).classList.add('active');
                    document.querySelector('.language-switch .navbar-nav-link').innerHTML = document.querySelector('.' + ruLangClass).innerHTML;
                }

                // Add responsive classes if toggler is not hidden on mobile
                document.querySelector('.language-switch .navbar-nav-link span').classList.add('d-none', 'd-lg-inline-block', 'me-1');
            });


            // Change languages in navbar
            // -------------------------

            elements.forEach(function(toggler) {
                toggler.addEventListener('click', function(e) {

                    // Toggle active class
                    elements.forEach(function(link) {
                        link.classList.remove('active');
                    });
                    toggler.classList.add('active');

                    // Display selected languate text and flag
                    toggler.closest('.language-switch').querySelector('.navbar-nav-link').innerHTML = toggler.innerHTML;
                    toggler.closest('.language-switch').querySelector('.navbar-nav-link span').classList.add('d-none', 'd-lg-inline-block', 'me-1');

                    // Notification
                    // _componentNoty('Language has been changed to: ' + '<span class="font-weight-semibold text-uppercase">' + i18next.language + '</span>');

                    // Re-init translation service
                    i18next.on('languageChanged', function() {
                        selector.forEach(function(item) {
                            item.innerHTML = i18next.t(item.getAttribute("data-i18n"));
                        });
                    });

                    // Switch language
                    toggler.classList.contains(enLangClass) && i18next.changeLanguage('en');
                    toggler.classList.contains(ruLangClass) && i18next.changeLanguage('ru');
                });
            });
        };

        return {
            init: function() {
                _componentI18nextCallbacks();
            }
        }
    }();

    document.addEventListener('DOMContentLoaded', function() {
        I18nextCallbacks.init();
    });

</script>
{/literal}