<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;
use Mnv\Models\Jobs;
use PHPExcel;
use PHPExcel_Cell_DataType;
use PHPExcel_Style_Alignment;
use PHPExcel_Writer_Excel2007;

/**
 * Class JobsAdmin
 * @package Mnv\Admin\Controllers
 */
class JobsAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $block = new Jobs($this->request);

        /** title */
        $this->smarty->assign('title', 'Участники');
        /** activeItem */
        $this->smarty->assign('activeItem', 'jobs');
        /** statuses */
        $statuses = lang('general:statuses');
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);

        $sections = Helpers::getSectionContent(0, 'nominations');
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);

        /** действия */
        if ($this->action == 'remove') {
            $result = $block->remove()
                ? array('status' => 200, 'message' => 'Работа удалена', 'type' => 'success')
                : array('status' => 403, 'message' => 'Ошибка при удаление работы', 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** статус */
        else if ($this->action == 'status') {
            $result = $block->status()
                ? array('data' => true, 'status' => $block->status, 'type' => 'success')
                : array('data' => false, 'status' => $block->status, 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }  else if ($this->action == 'reorder') {
            $i = 0;
            $block->data = [];
            foreach ($block->blockIds as $blockId) {
                $i++;
                $block->id = $blockId;
                $block->data['orderBy'] = $i;
                $block->update($block->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        }
        else if ($this->action == 'export') {
            $result = array();
            $block->filter = array_filter([
                'status'        => $this->status,
                'query'         => $this->query,
                'section'       => $this->filterSection,
            ]);

            $block->all( 100000, 1);

            $xls = new PHPExcel();
            $xls->getProperties()->setTitle("Список работ");
            $xls->getProperties()->setSubject("работы");
            $xls->getProperties()->setCreated(gmdate('d.m.Y'));

            $sheet = $xls->getActiveSheet();

            $sheet->setTitle("Список работ");
            foreach(range('A', 'I') as $columnID) {
                $sheet->getColumnDimension($columnID)->setAutoSize(true);
            }


            $xls->setActiveSheetIndex(0);
            $sheet->SetCellValue('A1', 'ID')->getStyle("A1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->SetCellValue('B1', 'Статус');
            $sheet->SetCellValue('C1', 'Номинация');
            $sheet->SetCellValue('D1', 'Название Компании / Бренд');
            $sheet->SetCellValue('E1', 'Контактное лицо');
            $sheet->SetCellValue('F1', 'ИНН компании');
            $sheet->SetCellValue('G1', 'Номер телефона');
            $sheet->SetCellValue('H1', 'E-mail');
            $sheet->SetCellValue('I1', 'Описание');

            $sheet->getStyle("A1:I1")->getFont()->setSize(14)->setBold(true);

            $rowCount =	2;
            if (!empty($block->result)) {
                foreach ($block->result as $job) {
                    $job['section'] = $SECTIONS[$job['sectionId']] ? $SECTIONS[$job['sectionId']]['name'] : '';
//                    if (!empty($job['telegram'])) {
//                        if (strripos($job['telegram'], '998') !== false) {
//                            $job['telegram'] = preg_replace('/[^0-9]/', '', $job['telegram']);
//                            $job['telegram'] = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $job['telegram']);
//                        }
//                    }
                    if (!empty($job['phone'])) {
                        if (strripos($job['phone'], '998') !== false) {
                            $job['phone'] = preg_replace('/[^0-9]/', '', $job['phone']);
                            $job['phone'] = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $job['phone']);
                        }
                    }
                    $sheet->SetCellValue('A' . $rowCount, $job['jobId'])->getStyle('A' . $rowCount)->getFont()->setBold(true);
                    $sheet->SetCellValue('B' . $rowCount, lang('general:statuses:' . $job['status']));
                    $sheet->SetCellValue('C' . $rowCount, $job['section']);
                    $sheet->SetCellValue('D' . $rowCount, $job['brand'])->getStyle('D' . $rowCount)->getFont()->setBold(true);
                    $sheet->SetCellValue('E' . $rowCount, $job['fullName']);
//                    $sheet->SetCellValue('F' . $rowCount, $job['inn']);
                    $sheet->setCellValueExplicit('F' . $rowCount, (string)$job['inn'],PHPExcel_Cell_DataType::TYPE_STRING);
                    $sheet->setCellValueExplicit('G' . $rowCount, (string)$job['phone'],PHPExcel_Cell_DataType::TYPE_STRING);
                    $sheet->SetCellValue('H' . $rowCount, $job['email']);
                    $sheet->SetCellValue('I' . $rowCount, $job['content']);
                    $rowCount++;
                }
            }

            header("Expires: Mon, 1 Apr 1974 05:00:00 GMT");
            header("Last-Modified: " . gmdate("D,d M YH:i:s") . " GMT");
            header("Cache-Control: no-cache, must-revalidate");
            header("Pragma: no-cache");
            header("Content-type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            header("Content-Disposition: attachment; filename=jobs.xlsx");

            $objWriter = new PHPExcel_Writer_Excel2007($xls);
            ob_end_clean();

            $objWriter->save('php://output');
            exit();

        }
        else {

            /** Фильтровать контент */
            $block->filter = array_filter([
                'status'        => $this->status,
                'query'         => $this->query,
                'section'       => $this->filterSection,
            ]);

            /** Получение всего контента */
            $block->all($this->limit, $this->page);
            $jobs = collect($block->result)->map(function ($item) use ($SECTIONS, $block) {
                $item['statusName']  = lang('general:statuses:' . $item['status']);
                $item['section']     = $SECTIONS[$item['sectionId']] ?? array();

                $item['image']          = !empty($item['image']['original']) ? $item['image']['original'] : GLOBAL_URL .'/admin/assets/img/no_images.jpg';
                return $item;
            })->all();

//            print_r($blocks);

            /** pagination */
            $block->total();
            $pages = getPageNums($block->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('jobs', $jobs);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('page', $this->page);

        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }



        /** Права доступа к данному шаблону */
        if ($this->permissions('jobs')) {
            return $this->smarty->fetch('views/jobs/jobs.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }


}